﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class AcceptFriendRequest : BaseAction
    {
        private readonly int _friendID;

        public AcceptFriendRequest(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("ConfirmFriendship", svc => svc.ConfirmFriendship(new ConfirmFriendshipRequest {FriendID = _friendID}));
                if (resp.Status != ConfirmFriendshipStatus.Successful)
                {
                    message = "Failed to confirm friendship. Service responded with " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to confirm friendship. " + ex.Message;
                return false;
            }
        }
    }
}
