﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class AcceptGroupCall : BaseAction
    {
        private readonly Guid _groupID;
        private readonly string _inviteCode;

        public Version ClientVersion { get; set; }

        public AcceptGroupCall(Guid groupID, string inviteCode)
        {
            _groupID = groupID;
            _inviteCode = inviteCode;

            ClientVersion = new Version(6, 2, 0, 0);
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("Accept", svc => svc.RespondToCall(new RespondToCallRequest {Accepted = true, GroupID = _groupID, InviteUrl = _inviteCode}));

                if (resp.Status != RespondToCallStatus.Successful)
                {
                    message = "Failed to accept voice call. Service responded with " + resp.Status;
                    return false;
                }

                var callResp = client.WebClient.Call("CallGroup", svc => svc.CallGroup(new CallGroupRequest
                {
                    ClientVersion = ClientVersion.ToString(),
                    GroupID = _groupID,
                    SendInvitation = false
                }));
                if (callResp.Status != VoiceSessionRequestStatus.Successful)
                {
                    message = "Failed to call group. Service responded with " + callResp.Status;
                    return false;
                }

                client.VoiceRuntimeClient.JoinGroupCall(client.CurrentUser, _inviteCode, _groupID, callResp.AccessToken);
                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Unexpected exception. " + ex.Message;
                return false;
            }
        }
    }
}
