﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public enum RequestFriendResponseType
    {
        Error,
        Success,
        TooManyFriends,
        AlreadyRequested
    }

    public class RequestFriend : BaseAction<RequestFriendResponseType>
    {
        private readonly int _userID;
        private readonly string _knownIdentity;

        public string InvitationMessage { get; set; }

        public bool IsFromSuggestion { get; set; }

        public RequestFriend(int userID, string knownIdentity)
        {
            _userID = userID;
            _knownIdentity = knownIdentity;
        }

        protected internal override bool Execute(TestClient client, out RequestFriendResponseType responseType, out string message)
        {
            try
            {
                var response = client.WebClient.Call("FriendRequest", svc => svc.RequestFriendship(new FriendshipRequest
                {
                    FriendID = _userID,
                    KnownIdentity = _knownIdentity,
                    InvitationMessage = InvitationMessage,
                    IsFromSuggestion = IsFromSuggestion
                }));


                switch (response.Status)
                {
                    case RequestFriendshipStatus.Successful:
                        message = null;
                        responseType = RequestFriendResponseType.Success;
                        return true;
                    case RequestFriendshipStatus.AlreadyRequested:
                        message = string.Format("Failed to send friendship request to {0} ({1}). Status={2}.", _knownIdentity, _userID, response.Status);
                        responseType = RequestFriendResponseType.AlreadyRequested;
                        return false;
                    case RequestFriendshipStatus.MaximumFriends:
                        message = string.Format("Failed to send friendship request to {0} ({1}). Status={2}.", _knownIdentity, _userID, response.Status);
                        responseType = RequestFriendResponseType.TooManyFriends;
                        return false;
                    default:
                        message = string.Format("Failed to send friendship request to {0} ({1}). Status={2}.", _knownIdentity, _userID, response.Status);
                        responseType = RequestFriendResponseType.Error;
                        return false;
                }

            }
            catch (Exception ex)
            {
                message = "Failed to request friendship. " + ex.Message;
                responseType = RequestFriendResponseType.Error;
                return false;
            }
        }
    }
}
