﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class AddGroupMember : BaseAction
    {
        private readonly Guid _groupID;
        private readonly int[] _membersToAdd;

        public AddGroupMember(Guid groupID, int[] membersToAdd)
        {
            _groupID = groupID;
            _membersToAdd = membersToAdd;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {

                var result = client.WebClient.Call("AddGroupMembers", svc => svc.AddUsersToGroup(new AddUserToGroupRequest
                {
                    GroupID = _groupID,
                    UserIDs = _membersToAdd
                }));
                if (result.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to add members to Group {0}. Status={1}. {2}", _groupID, result.Status, result.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to add group member. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
