﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.FriendsService.Tester.Actions
{
    /// <summary>
    /// Used for actions with no important returned information.
    /// </summary>
    public abstract class BaseAction
    {
        protected internal abstract bool Execute(TestClient client, out string errorMessage);
    }

    /// <summary>
    /// Used for actions with an important piece of returned information like a newly created object's ID.
    /// </summary>
    /// <typeparam name="TResult">The type of result.</typeparam>
    public abstract class BaseAction<TResult>
    {
        protected internal abstract bool Execute(TestClient client, out TResult result, out string errorMessage);
    }
}
