﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class CallFriend : BaseAction<string>
    {
        private readonly int _friendID;

        public Version ClientVersion { get; set; }

        public bool SendInvitation { get; set; }

        public bool Force { get; set; }

        public CallFriend(int friendID)
        {
            _friendID = friendID;

            ClientVersion = new Version(6, 2, 0, 0);
            SendInvitation = true;
            Force = false;
        }

        protected internal override bool Execute(TestClient client, out string inviteCode, out string message)
        {
            try
            {
                if (client.VoiceRuntimeClient.IsInCall)
                {
                    message = "Cannot call friend while already in a call. Hang up first.";
                    inviteCode = null;
                    return false;
                }
                
                var resp = client.WebClient.Call("CallFriend", svc => svc.CallFriend(new CallFriendRequest
                {
                    ClientVersion = ClientVersion.ToString(),
                    FriendID = _friendID,
                    SendInvitation = SendInvitation,
                    Force = Force
                }));

                if (resp.Status!=VoiceSessionRequestStatus.Successful)
                {
                    message = string.Format("[{0}] Failed to call friend {1}. Web Service replied {2}", client.UserID, _friendID, resp.Status);
                    inviteCode = null;
                    return false;
                }

                client.VoiceRuntimeClient.JoinFriendCall(client.CurrentUser, resp.InviteUrl, _friendID, resp.AccessToken);

                inviteCode = resp.InviteUrl;
                message = null;
                return true;
            }
            catch (Exception ex)
            {
                inviteCode = null;
                message = string.Format("[{0}] Failed to call friend {1}. Exception: {2}", client.UserID, _friendID, ex.Message);
                return false;
            }
        }
    }
}
