﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class CallGroup : BaseAction<string>
    {
        private readonly Guid _groupID;

        public Version ClientVersion { get; set; }
        public bool SendInvitation { get; set; }
        public bool Force { get; set; }
        public int[] TargetUserIDs { get; set; }

        public CallGroup(Guid groupID)
        {
            _groupID = groupID;

            ClientVersion = new Version(6, 2, 0, 0);
            SendInvitation = true;
            Force = false;
            TargetUserIDs = null;
        }

        protected internal override bool Execute(TestClient client, out string inviteCode, out string message)
        {
            try
            {
                if (client.VoiceRuntimeClient.IsInCall)
                {
                    message = "Cannot call group while already in a call. Hang up first.";
                    inviteCode = null;
                    return false;
                }

                var resp = client.WebClient.Call("CallGroup", svc => svc.CallGroup(new CallGroupRequest
                {
                    GroupID = _groupID,
                    ClientVersion = ClientVersion.ToString(),
                    SendInvitation = SendInvitation,
                    Force = Force,
                    TargetUserIDs = TargetUserIDs
                }));

                if(resp.Status!=VoiceSessionRequestStatus.Successful)
                {
                    message = string.Format("Failed to call group. Web Service replied {0}", resp.Status);
                    inviteCode = null;
                    return false;
                }

                client.VoiceRuntimeClient.JoinGroupCall(client.CurrentUser, resp.InviteUrl, _groupID, resp.AccessToken);

                message = null;
                inviteCode = resp.InviteUrl;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to call group. Unexpected exception: " + ex.Message;
                inviteCode = null;
                return false;
            }
        }
    }
}
