﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ChangeGameStatus : BaseAction
    {
        private readonly int _gameID;

        public string StatusMessage { get; set; }

        public bool IsRunning { get; set; }

        public int GameState { get; set; }

        public ChangeGameStatus(int gameID)
        {
            _gameID = gameID;

            IsRunning = gameID > 0;
            GameState = 1;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("ChangeGameStatus", svc => svc.ChangeGameStatus(new ChangeGameStatusRequest
                {
                    GameID = _gameID,
                    GameStatusMessage = StatusMessage,
                    IsRunning = IsRunning,
                    GameState = GameState
                }));

                if (resp.Status != ChangeGameStatusStatus.Successful)
                {
                    message = "Failed to change game status. Web service returned " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to change game status. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
