﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ChangeGroupInfo : BaseAction
    {
        private readonly Guid _groupID;

        public string Title { get; set; }
        public string AvatarUrl { get; set; }
        public string MessageOfTheDay { get; set; }
        public bool? AllowTemporaryChildGroups { get; set; }
        public bool? ForcePushToTalk { get; set; }

        public ChangeGroupInfo(Guid groupID)
        {
            _groupID = groupID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("ChangeGroup", svc => svc.ChangeGroupInfo(new ChangeGroupRequest
                {
                    AllowTemporaryChildGroups = AllowTemporaryChildGroups,
                    AvatarUrl = string.IsNullOrWhiteSpace(AvatarUrl) ? null : AvatarUrl,
                    ForcePushToTalk = ForcePushToTalk,
                    GroupID = _groupID,
                    MessageOfTheDay = string.IsNullOrWhiteSpace(MessageOfTheDay) ? null : MessageOfTheDay,
                    Title = string.IsNullOrWhiteSpace(Title) ? null : Title
                }));

                if (resp.Status != BasicServiceResponseStatus.Successful)
                {
                    message = "Failed to change group info. Web service returned " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to change group info. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
