﻿using System;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;

namespace Curse.FriendsService.Tester.Actions
{
    public class ChangeGroupNotificationPreferences : BaseAction
    {
        private readonly Guid _groupID;
        private readonly NotificationPreference _preference;

        public string[] Filters { get; set; }

        public ChangeGroupNotificationPreferences(Guid groupID, NotificationPreference preference)
        {
            _groupID = groupID;
            _preference = preference;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var response = client.WebClient.Call("ChangeNotificationPrefs", svc => svc.ChangeGroupNotificationPreferences(new ChangeGroupNotificationPreferencesRequest
                {
                    GroupID = _groupID,
                    Preference = _preference,
                    FilterSet = Filters
                }));

                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to change Group {0} Notification Preference to {1}. Status={2}. {3}", _groupID, _preference, response.Status,
                        response.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to change group notification preferences. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
