﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ChangeProfile : BaseAction
    {
        public string AvatarUrl { get; set; }

        public string AboutMe { get; set; }

        public string City { get; set; }

        public string CountryCode { get; set; }

        public string Name { get; set; }
        
        public string State { get;set; }

        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("ChangeProfile", svc => svc.ChangeProfile(new ChangeProfileRequest
                {
                    AvatarUrl = AvatarUrl,
                    AboutMe = AboutMe,
                    City = City,
                    CountryCode = CountryCode,
                    Name = Name,
                    State = State
                }));

                if (resp.Status != ChangeProfileStatus.Successful)
                {
                    errorMessage = "Failed to change profile. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to change profile. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
