﻿using System;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;

namespace Curse.FriendsService.Tester.Actions
{
    public class ChangeStatus : BaseAction
    {
        private readonly UserConnectionStatus _status;

        public string StatusMessage { get; set; }

        public ChangeStatus(UserConnectionStatus newStatus)
        {
            _status = newStatus;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("ChangeStatus", svc => svc.ChangeStatus(new ChangeStatusRequest
                {
                    Status = _status,
                    CustomStatusMessage = StatusMessage,
                    MachineKey = client.MachineKey
                }));

                if (resp.Status != ChangeStatusStatus.Successful)
                {
                    message = "Failed to change status. Web service returned " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to change status. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
