﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ClaimGroupInvite : BaseAction
    {
        private readonly string _inviteCode;

        public ClaimGroupInvite(string inviteCode)
        {
            _inviteCode = inviteCode;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var response = client.WebClient.Call("ClaimGroupInvite", svc => svc.ProcessGroupInvite(new ProcessInviteRequest {InviteCode = _inviteCode}));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to claim Group Invite {0}. Status={1}. {2}", _inviteCode, response.Status, response.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to claim group invite. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
