﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ConfirmFriend : BaseAction
    {
        private readonly int _friendID;

        public ConfirmFriend(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("ConfirmFriendship", svc => svc.ConfirmFriendship(new ConfirmFriendshipRequest
                {
                    FriendID = _friendID
                }));

                if (resp.Status != ConfirmFriendshipStatus.Successful)
                {
                    errorMessage = "Failed to confirm friendship. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to confirm friendship. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
