﻿using System;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;

namespace Curse.FriendsService.Tester.Actions
{
    public class CreateGroup : BaseAction<Guid>
    {
        private readonly string _title;
        private readonly GroupType _type;

        public int[] NewMembers { get; set; }

        public Guid ParentGroupID { get; set; }

        public string LobbyTitle { get; set; }

        public string AvatarUrl { get; set; }

        public string MessageOfTheDay { get; set; }

        public CreateGroup(string title, GroupType type)
        {
            _title = title;
            _type = type;

            if (_type == GroupType.Large)
            {
                LobbyTitle = title + " Lobby";
            }
        }

        protected internal override bool Execute(TestClient client, out Guid groupID, out string message)
        {
            try
            {
                var response = client.WebClient.Call("CreateGroup", svc => svc.CreateGroup(new CreateGroupRequest
                {
                    Title = _title,
                    Type = _type,
                    RecipientsUserIDs = NewMembers,
                    ParentGroupID = ParentGroupID,
                    LobbyName = LobbyTitle,
                    OwnerRoleName = "Owner",
                    GuestRoleName = "Guest"
                }));

                if (response.Status != CreateGroupStatus.Successful)
                {
                    message = string.Format("Failed to create group. Status = {0}. {1}", response.Status, response.ErrorMessage);
                    groupID = Guid.Empty;
                    return false;
                }

                message = null;
                groupID = response.GroupID;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to create group. Exception: " + ex.Message;
                groupID = Guid.Empty;
                return false;
            }
        }
    }
}
