﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class CreateGroupInvite: BaseAction<string>
    {
        private readonly Guid _groupID;

        public TimeSpan? LifeTime { get; set; }

        public bool AutoRemoveGuests { get; set; }

        public CreateGroupInvite(Guid groupID)
        {
            _groupID = groupID;
        }

        protected internal override bool Execute(TestClient client, out string inviteCode, out string message)
        {
            try
            {
                var result = client.WebClient.Call("CreateGroupInvite", svc => svc.CreateGroupInvite(new CreateGroupInviteRequest
                {
                    GroupID = _groupID,
                    Lifespan = LifeTime,
                    AutoRemoveMembers = AutoRemoveGuests
                }));
                if (result.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to create an Invitation for Group {0}. Status = {1}", _groupID, result.Status);
                    inviteCode = null;
                    return false;
                }

                message = null;
                inviteCode = result.InviteCode;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to create group invite. Exception: " + ex.Message;
                inviteCode = null;
                return false;
            }
        }
    }
}
