﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeclineFriendCall : BaseAction
    {
        private readonly int _friendID;
        private readonly string _inviteCode;

        public DeclineFriendCall(int friendID, string inviteCode)
        {
            _friendID = friendID;
            _inviteCode = inviteCode;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("Decline", svc => svc.RespondToCall(new RespondToCallRequest { Accepted = false, FriendID = _friendID, InviteUrl = _inviteCode }));

                if (resp.Status != RespondToCallStatus.Successful)
                {
                    message = "Failed to decline friend call. Web service responded with " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to decline friend call. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
