﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeclineFriendRequest : BaseAction
    {
        private readonly int _friendID;

        public bool BlockFutureRequests { get; set; }

        public DeclineFriendRequest(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("DeclineFriendship", svc => svc.DeclineFriendship(new DeclineFriendshipRequest {FriendID = _friendID, BlockFutureRequests = BlockFutureRequests}));
                if (resp.Status != DeclineFriendshipStatus.Successful)
                {
                    message = "Failed to decline friendship. Web service returned " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to decline friend request. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
