﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeclineFriendSuggestion : BaseAction
    {
        private readonly int _friendID;

        public DeclineFriendSuggestion(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("DeclineFriendSuggestion", svc => svc.DeclineFriendSuggestion(new DeclineFriendSuggestionRequest
                {
                    FriendID = _friendID
                }));

                if (resp.Status != BasicServiceResponseStatus.Successful)
                {
                    errorMessage = "Failed to decline friend suggestion. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to decline friend suggestion. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
