﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeclineGroupCall : BaseAction
    {
        private readonly Guid _groupID;
        private readonly string _inviteCode;

        public DeclineGroupCall(Guid groupID, string inviteCode)
        {
            _groupID = groupID;
            _inviteCode = inviteCode;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("Decline", svc => svc.RespondToCall(new RespondToCallRequest { Accepted = false, GroupID = _groupID, InviteUrl = _inviteCode }));

                if (resp.Status != RespondToCallStatus.Successful)
                {
                    message = "Failed to decline group call. Web service responded with " + resp.Status;
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to decline group call. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
