﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeleteGroup : BaseAction
    {
        private readonly Guid _groupID;

        public DeleteGroup(Guid groupID)
        {
            _groupID = groupID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var response = client.WebClient.Call("DeleteGroup", svc => svc.DeleteGroup(new DeleteGroupRequest {GroupID = _groupID}));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message= string.Format("Failed to delete {0}. Status = {1}. {2}", _groupID, response.Status, response.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to delete group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
