﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class DeleteGroupInvite : BaseAction
    {
        private readonly string _inviteCode;

        public bool RemoveGuests { get; set; }

        public DeleteGroupInvite(string inviteCode)
        {
            _inviteCode = inviteCode;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var response = client.WebClient.Call("DeleteGroupInvite", svc => svc.DeleteGroupInvite(new DeleteGroupInviteRequest
                {
                    InviteCode = _inviteCode,
                    RemoveGuests = RemoveGuests
                }));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to delete group invite {0}. Status={1}. {2}", _inviteCode, response.Status, response.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to delete group invite. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
