﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class FindFriends : BaseAction<FriendSearchResponse>
    {
        private readonly string _query;

        public FindFriends(string query)
        {
            _query = query;
        }

        protected internal override bool Execute(TestClient client, out FriendSearchResponse results, out string errorMessage)
        {
            try
            {
                var response = client.WebClient.Call("FindFriends", svc => svc.FindFriends(new FriendSearchRequest {QueryString = _query}));
                if (response.Status != FriendSearchStatus.Successful)
                {
                    results = null;
                    errorMessage = "Failed to find friends. Service returned " + response.Status;
                    return false;
                }

                results = response;
                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                results = null;
                errorMessage = "Failed to find friends. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
