﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class GetGroupDetails : BaseAction<GetGroupDetailsResponse>
    {
        private readonly Guid _groupID;

        public GetGroupDetails(Guid groupID)
        {
            _groupID = groupID;
        }

        public bool IncludePermissions { get; set; }

        public bool IncludeRoleNames { get; set; }

        public bool IncludeDeletedChannels { get; set; }

        protected internal override bool Execute(TestClient client, out GetGroupDetailsResponse result, out string errorMessage)
        {
            try
            {
                var response = client.WebClient.Call("GetGroupDetails", svc => svc.GetGroupDetails(new GroupDetailsRequest
                {
                    GroupID = _groupID,
                    IncludePermissions = IncludePermissions,
                    IncludeRoleNames = IncludeRoleNames,
                    ShowDeletedChannels = IncludeDeletedChannels
                }));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    errorMessage = string.Format("Failed to get details of Group {0}. Status = {1}", _groupID, response.Status);
                    result = null;
                    return false;
                }

                errorMessage = null;
                result = response;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to get group details. Exception: " + ex.Message;
                result = null;
                return false;
            }
        }
    }
}
