﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class GetGroupInvites : BaseAction<GroupInvitation[]>
    {
        private readonly Guid _groupID;

        public bool ActiveOnly { get; set; }

        public bool MineOnly { get; set; }

        public GetGroupInvites(Guid groupID)
        {
            _groupID = groupID;

            ActiveOnly = true;
        }

        protected internal override bool Execute(TestClient client, out GroupInvitation[] invites, out string message)
        {
            try
            {
                var response = client.WebClient.Call("GetGroupInvites", svc => svc.GetCreatedGroupInvites(new GetCreatedGroupInvitesRequest
                {
                    GroupID = _groupID,
                    ActiveOnly = ActiveOnly,
                    MineOnly = MineOnly
                }));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message = "Failed to get group invites. Web service responded with " + response.Status;
                    invites = null;
                    return false;
                }

                message = null;
                invites = response.Invites;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to get group invites. Exception: " + ex.Message;
                invites = null;
                return false;
            }
        }
    }
}
