﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class GetMyFriends : BaseAction<GetMyFriendsResponse>
    {
        protected internal override bool Execute(TestClient client, out GetMyFriendsResponse result, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("GetMyFriends", svc => svc.GetMyFriends());

                if (resp.Status != GetMyFriendsStatus.Successful)
                {
                    errorMessage = "Failed to get friends. Web service responded with " + resp.Status;
                    result = null;
                    return false;
                }

                errorMessage = null;
                result = resp;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to get friends. Exception: " + ex.Message;
                result = null;
                return false;
            }
        }
    }
}
