﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class GetMyGroups : BaseAction<GetMyGroupsResponse>
    {
        protected internal override bool Execute(TestClient client, out GetMyGroupsResponse result, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("GetMyGroups", svc => svc.GetMyGroups());

                if (resp.Status != BasicServiceResponseStatus.Successful)
                {
                    result = null;
                    errorMessage = "Failed to get groups. Web service responded with " + resp.Status;
                    return false;
                }

                result = resp;
                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                result = null;
                errorMessage = "Failed to get groups. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
