﻿using System;
using System.Linq;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class GetProfile : BaseAction<UserProfileResponse>
    {
        private readonly int _userID;

        public GetProfile(int userID)
        {
            _userID = userID;
        }

        protected internal override bool Execute(TestClient client, out UserProfileResponse profile, out string errorMessage)
        {
            try
            {
                var response = client.WebClient.Call("GetProfile", svc => svc.GetUserProfile(_userID));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    errorMessage = "Failed to get profile. Web service responded with " + response.Status;
                    profile = null;
                    return false;
                }
                profile = response;
                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to get profile. Exception: " + ex.Message;
                profile = null;
                return false;
            }
        }
    }
}
