﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class JoinPromoGroup : BaseAction
    {
        private readonly string _apiKey;
        private readonly string _email;
        private readonly Guid _promoID;
        private readonly int _userID;
        private readonly string _username;

        public JoinPromoGroup(Guid promoID, int userID, string username, string email, string apiKey)
        {
            _promoID = promoID;
            _username = username;
            _userID = userID;
            _email = email;
            _apiKey = apiKey;
        }

        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("PlaceUserInPromoGroup", svc => svc.PlaceUserInGroupPromo(new PlaceUserInPromoGroupRequest
                {
                    ApiKey = _apiKey,
                    Email = _email,
                    PromoID = _promoID,
                    UserID = _userID,
                    Username = _username
                }));

                if (resp.Status != PlaceUserInPromoGroupStatus.Successful)
                {
                    errorMessage = "Failed to join promo group. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to join promo group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
