﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class LeaveGroup: BaseAction
    {
        private readonly Guid _groupID;

        public LeaveGroup(Guid groupID)
        {
            _groupID = groupID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var result = client.WebClient.Call("LeaveGroup", svc => svc.LeaveGroup(new LeaveGroupRequest {GroupID = _groupID}));
                if (result.Status != BasicServiceResponseStatus.Successful)
                {
                    message= string.Format("Failed to leave Group {0}. Status={1}. {2}", _groupID, result.Status, result.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to leave group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
