﻿using System;

namespace Curse.FriendsService.Tester.Actions
{
    public class MessageFriend: BaseAction
    {
        private readonly int _friendID;
        private readonly string _message;

        public MessageFriend(int friendID, string message)
        {
            _friendID = friendID;
            _message = message;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                client.NotificationClient.SendInstantMessage(_friendID, _message);

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to message friend. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
