﻿using System;

namespace Curse.FriendsService.Tester.Actions
{
    public class MessageGroup: BaseAction
    {
        private readonly Guid _groupID;
        private readonly string _message;

        public MessageGroup(Guid groupID, string message)
        {
            _groupID = groupID;
            _message = message;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                client.NotificationClient.SendGroupMessage(_groupID, _message);

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to message group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
