﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class RemoveFriend : BaseAction
    {
        private readonly int _friendID;

        public RemoveFriend(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var response = client.WebClient.Call("RemoveFriend", svc => svc.RemoveFriendship(new RemoveFriendshipRequest {FriendID = _friendID}));
                if (response.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to unfriend {0}. Status={1}. {2}", _friendID, response.Status, response.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to remove friendship. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
