﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class RemoveGroupMember : BaseAction
    {
        private readonly Guid _groupID;
        private readonly int[] _membersToRemove;

        public RemoveGroupMember(Guid groupID, int[] membersToRemove)
        {
            _groupID = groupID;
            _membersToRemove = membersToRemove;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var result = client.WebClient.Call("RemoveGroupMembers", svc => svc.RemoveUsersFromGroup(new RemoveUsersFromGroupRequest
                {
                    GroupID = _groupID,
                    UserIDs = _membersToRemove
                }));
                if (result.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to remove members from group {0}. Status={1}. {2}", _groupID, result.Status, result.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to remove group members. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
