﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class RenameFriend : BaseAction
    {
        private readonly int _friendID;
        private readonly string _nickname;

        public RenameFriend(int friendID, string nickname)
        {
            _friendID = friendID;
            _nickname = nickname;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("RenameFriend", svc => svc.RenameFriend(new RenameFriendRequest
                {
                    FriendID = _friendID,
                    Nickname = _nickname
                }));

                if (resp.Status != RenameFriendStatus.Successful)
                {
                    message = string.Format("[{0}] Failed to rename friend {1}. Web service responded with {2}", client.UserID, _friendID, resp.Status);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = string.Format("[{0}] Failed to rename friend {1}. Exception: {2}", client.UserID, _friendID, ex.Message);
                return false;
            }
        }
    }
}
