﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class RestoreGroup : BaseAction
    {
        private readonly Guid _groupID;

        public RestoreGroup(Guid groupID)
        {
            _groupID = groupID;
        }

        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("RestoreChannel", svc => svc.RestoreChannel(new RestoreGroupRequest
                {
                    GroupID = _groupID
                }));

                if (resp.Status != BasicServiceResponseStatus.Successful)
                {
                    errorMessage = "Failed to restore group. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to restore group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
