﻿using System;

namespace Curse.FriendsService.Tester.Actions
{
    public class SendConversationRead : BaseAction
    {
        private readonly Guid? _groupID;
        private readonly int? _friendID;

        public SendConversationRead(Guid groupID)
        {
            _groupID = groupID;
        }

        public SendConversationRead(int friendID)
        {
            _friendID = friendID;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                if (_groupID.HasValue)
                {
                    client.NotificationClient.SendConversationRead(_groupID.Value);
                }
                else if (_friendID.HasValue)
                {
                    client.NotificationClient.SendConversationRead(_friendID.Value);
                }
                else
                {
                    message = "Failed to send conversation read. A Friend ID or Group ID must be specified";
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to send conversation read. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
