﻿using System;

namespace Curse.FriendsService.Tester.Actions
{
    public class SyncOfflineMessages : BaseAction
    {
        private readonly DateTime _timeToSync;

        public Guid? GroupID { get; set; }

        public int? FriendID { get; set; }

        public SyncOfflineMessages(DateTime timeToSync)
        {
            _timeToSync = timeToSync;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                client.NotificationClient.SendOfflineMessageRequest(_timeToSync, FriendID, GroupID);

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to sync offline messages. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
