﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ToggleFavoriteFriend : BaseAction
    {
        private readonly int _friendID;
        private readonly bool _isFavorite;

        public ToggleFavoriteFriend(int friendID, bool isFavorite)
        {
            _friendID = friendID;
            _isFavorite = isFavorite;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var favoriteString = _isFavorite ? "favorite" : "not a favorite";
                var response = client.WebClient.Call("ToggleFavoriteFriend", svc => svc.ToggleFavorite(new ToggleFavoriteRequest
                {
                    FriendID = _friendID,
                    IsFavorite = _isFavorite
                }));
                if (response.Status != ToggleFavoriteStatus.Successful)
                {
                    message= string.Format("Failed to set friend {0} to {1}. Status={2}.", _friendID, favoriteString, response.Status);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to toggle favorite friend. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
