﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class ToggleFavoriteGroup : BaseAction
    {
        private readonly Guid _groupID;
        private readonly bool _isFavorite;

        public ToggleFavoriteGroup(Guid groupID, bool isFavorite)
        {
            _groupID = groupID;
            _isFavorite = isFavorite;
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var result = client.WebClient.Call("ToggleFavoriteGroup", svc => svc.ToggleFavoriteGroup(new FavoriteGroupRequest
                {
                    GroupID = _groupID,
                    IsFavorite = _isFavorite
                }));
                if (result.Status != BasicServiceResponseStatus.Successful)
                {
                    message = string.Format("Failed to set Group {0} to {1}. Status = {2}. {3}", _groupID, _isFavorite ? "favorite" : "not favorite", result.Status, result.StatusMessage);
                    return false;
                }

                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Failed to toggle favorite group. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
