﻿using System;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class UnregisterEndpoint : BaseAction
    {
        protected internal override bool Execute(TestClient client, out string errorMessage)
        {
            try
            {
                var resp = client.WebClient.Call("Unregister Endpoint", c => c.UnregisterEndpoint(new UnregisterEndpointRequest {MachineKey = client.MachineKey}));

                if (resp.Status != BasicServiceResponseStatus.Successful)
                {
                    errorMessage = "Failed to unregister endpoint. Web service responded with " + resp.Status;
                    return false;
                }

                errorMessage = null;
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = "Failed to unregister endpoint. Exception: " + ex.Message;
                return false;
            }
        }
    }
}
