﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;

namespace Curse.FriendsService.Tester.Events
{
    public interface IDomainEvent
    {
        
    }

    public class EventDispatcher
    {
        private ConcurrentDictionary<Type, ConcurrentBag<Delegate>> _actions=new ConcurrentDictionary<Type, ConcurrentBag<Delegate>>();

        //Registers a callback for the given domain event
        public void Register<T>(Action<T> callback) where T : IDomainEvent
        {
            var type = typeof (T);

            ConcurrentBag<Delegate> delegates;
            if(!_actions.TryGetValue(type,out delegates))
            {
                delegates = new ConcurrentBag<Delegate>();
                _actions.TryAdd(type, delegates);
            }

            delegates.Add(callback);
        }

        //Clears callbacks passed to Register on the current thread
        public void ClearCallbacks()
        {
            _actions = null;
        }

        //Raises the given domain event
        public void Raise<T>(T args) where T : IDomainEvent
        {
            ConcurrentBag<Delegate> delegates;
            if (_actions.TryGetValue(typeof (T), out delegates))
            {
                foreach (var action in delegates)
                {
                    ((Action<T>) action)(args);
                }
            }
        }
    }
}
