﻿using System;
using System.Diagnostics.Contracts;
using Curse.SocketMessages;
using Newtonsoft.Json;

namespace Curse.FriendsService.Tester.Events
{
    public static class EventExtensions
    {
        private static readonly JsonSerializerSettings Settings = new JsonSerializerSettings {ConstructorHandling = ConstructorHandling.AllowNonPublicDefaultConstructor};

        public static TEvent ToDomainEvent<TEvent>(this object notification) where TEvent : IDomainEvent
        {
            var json = JsonConvert.SerializeObject(notification);
            return JsonConvert.DeserializeObject<TEvent>(json, Settings);
        }
    }
}
