﻿using System;
using System.Collections.Generic;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.FriendsService.Tester
{
    public class Group
    {

        //public Group(GroupMemberNotification value)
        //{
        //    GroupID = value.GroupID;
        //    RootGroupID = value.RootGroupID;
        //    ParentGroupID = value.ParentGroupID;
        //    GroupTitle = value.GroupTitle;
        //    GroupAvatar = value.GroupAvatarUrl;
        //    GroupType = value.GroupType;
        //    IsFavorite = value.IsFavorite;
        //    NotificationPreference = value.NotificationPreference;
        //    if (value.NotificationFilters != null)
        //    {
        //        NotificationFilters = new HashSet<string>(value.NotificationFilters);
        //    }
        //}

        public Group(GroupNotification value)
        {
            UpdateFromNotification(value);
        }

        public void UpdateFromNotification(GroupNotification value)
        {
            GroupID = value.GroupID;
            RootGroupID = value.RootGroupID;
            ParentGroupID = value.ParentGroupID;
            DisplayOrder = value.DisplayOrder;
            ForcePTT = value.ForcePushToTalk;
            Status = value.Status;
            AllowTempChannels = value.AllowTemporaryChildGroups;

            if (!value.MetaDataOnly)
            {
                GroupTitle = value.GroupTitle;
                GroupType = value.GroupType;
                MessageOfTheDay = value.MessageOfTheDay;
                IsDefaultChannel = value.IsDefaultChannel;
                VoiceSessionCode = value.VoiceSessionCode;
                HasDetails = true;
            }
        }

        public bool HasDetails { get; set; }

        #region Global Properties

        public string GroupTitle
        {
            get;
            set;
        }
        
        public string GroupAvatar
        {
            get;
            set;
        }

        public Guid GroupID
        {
            get;
            set;
        }

        public Guid ParentGroupID
        {
            get;
            set;
        }

        public Guid RootGroupID
        {
            get;
            set;
        }
        
        public string VoiceSessionCode
        {
            get;
            set;
        }
        
        public string MessageOfTheDay
        {
            get;
            set;
        }

        public bool AllowTempChannels
        {
            get;
            set;
        }
        
        public GroupType GroupType
        {
            get;
            set;
        }

        public int DisplayOrder
        {
            get; 
            set;
        }

        public bool IsDefaultChannel
        {
            get;
            set;
        }

        public bool ForcePTT
        {
            get;
            set;
        }

        public GroupStatus Status
        {
            get;
            set;
        }

        #endregion

        #region User Specific an Properties

        public NotificationPreference NotificationPreference
        {
            get; 
            set;
        }

        public HashSet<string> NotificationFilters
        {
            get;
            set;
        }

        public bool IsFavorite
        {
            get;
            set;
        }

        #endregion
    }
}
