﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.FriendsService.Tester.Events;

namespace Curse.FriendsService.Tester.People
{
    public class CurrentUser : User
    {
        public CurrentUser(TestClient client) : base(client)
        {
            client.Events.Register<UserChanged>(UserChanged);
        }

        private void UserChanged(UserChanged e)
        {
            AvatarUrl = e.User.AvatarUrl;
            ConnectionStatus = e.User.ConnectionStatus;
            GameID = e.User.CurrentGameID;
            GameStatusMessage = e.User.CurrentGameStatusMessage;
            StatusMessage = e.User.CustomStatusMessage;
        }

        public string EncryptedPassword { get; set; }

        public string Token { get; set; }

        protected override void DoClear()
        {
            EncryptedPassword = null;
            Token = null;
        }
    }
}
