﻿using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.Events;

namespace Curse.FriendsService.Tester
{
    public class User
    {
        protected readonly TestClient Client;

        public User(TestClient client)
        {
            Client = client;
        }

        public void RefreshProfile()
        {
            string error;
            UserProfileResponse resp;
            if (!Client.Execute(new GetProfile(UserID), out resp, out error))
            {
                return;
            }

            AboutMe = resp.AboutMe;
            AvatarUrl = resp.AvatarUrl;
            Name = resp.Name;
            City = resp.City;
            State = resp.State;
            CountryCode = resp.CountryCode;

            UpdateProfileFields(resp);
        }

        protected virtual void UpdateProfileFields(UserProfileResponse profile)
        {

        }

        public void Clear()
        {
            UserID = 0;
            Username = null;
        }

        protected virtual void DoClear()
        {
            
        }

        public int UserID { get; set; }

        public string Username { get; set; }

        public UserConnectionStatus ConnectionStatus { get; set; }

        public string StatusMessage { get; set; }

        public int GameID { get; set; }

        public string GameStatusMessage { get; set; }

        public string AvatarUrl { get; set; }

        public string AboutMe { get; set; }

        public string Name { get; set; }

        public string City { get; set; }

        public string State { get; set; }

        public string CountryCode { get; set; }
    }
}
