﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Curse.FriendsService.Tester
{
    public static class RandomEx
    {
        private static int _seed = Environment.TickCount;

        private static readonly ThreadLocal<Random> _random = new ThreadLocal<Random>(
            () => new Random(Interlocked.Increment(ref _seed)));

        public static Random GetThreadRandom()
        {
            return _random.Value;
        }

        public static void Shuffle<T>(this Random random, T[] array)
        {
            // Fisher-Yates shuffle
            for (var i = array.Length - 1; i > 0; i--)
            {
                var k = random.Next(i + 1);
                var temp = array[i];
                array[i] = array[k];
                array[k] = temp;
            }
        }
    }
}
