﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using Curse.ServiceAuthentication.Models;

namespace Curse.FriendsService.Tester
{
    public static class ClientLogin
    {
        private static readonly string _curseforgeKey = "4baJYazVP9vRdDkra8t2xZk6rBwjX2VIoWOb+mbMhlKcgQxbqaMF63Rw4cXBHlqcI06i12uU03lN/ONaUvSa";
        private static readonly string _localEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly StringCipher _localCipher;

        static ClientLogin()
        {
            _localCipher = new StringCipher(_localEncryptionSeed);
        }

        public static string EncryptLocalString(string value)
        {
            return _localCipher.Encrypt(value);
        }

        public static string DecryptLocalString(string value)
        {
            string unencrypted = value;
            try
            {
                unencrypted = _localCipher.Decrypt(value);
            }
            catch { }
            return unencrypted;
        }

    }
}
