﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Enums;

namespace Curse.FriendsService.Tester
{
    public class Device
    {
        public DevicePlatform Platform { get; private set; }
        public string DeviceID { get; private set; }

        private Device(DevicePlatform platform, string deviceID)
        {
            Platform = platform;
            DeviceID = deviceID;
        }

        public static readonly Device Windows = new Device(
            DevicePlatform.Windows, 
            null);

        public static readonly Device iOS = new Device(
            DevicePlatform.iOS,
            "2c6978a0c6e20f4f84ff0142e297d96e4ff76dcd491c76bc1a2381bd01cb5619");

        public static readonly Device Android = new Device(
            DevicePlatform.Android,
            "APA91bF35khXTl31nT4ly5agHA_tkU_-RPC1EAdRq1IeQWSfz6D4qU7Beyw9VcRWpGhuxKA7O-bln0b2b4_zkyt03SN3JlYbyjtUQITwtCqBDvC2TlBHSU_TOLwFrFpUpNCqwvmm8kAzyxxR2ECgctTfXfCWXtfj1w");
    }
}
