﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Curse.FriendsService.Tester
{
    public static class EnumExtensions
    {
        public static string GetDescription(this Enum value)
        {
            var fi = value.GetType().GetField(value.ToString());
            var attribute = fi.GetCustomAttribute<DescriptionAttribute>();
            return attribute == null ? value.ToString() : attribute.Description;
        }

        public static T GetValueFromDescription<T>(this string description)
        {
            var type = typeof (T);
            if (!type.IsEnum)
            {
                throw new InvalidOperationException();
            }

            foreach (var fi in type.GetFields())
            {
                var attribute = fi.GetCustomAttribute<DescriptionAttribute>();
                if (description == fi.Name || (attribute != null && attribute.Description==description))
                {
                    return (T) fi.GetValue(null);
                }
            }

            throw new ArgumentException("Unknown value", "description");
        }
    }
}
